#Includes calculating Difference[trt-untrt] for bio_var1, bio_var2

#need to set working directory
#setwd()
source("01 data analysis.R") #the outputs of that script are full_summary and full_summary_bio1

full_summary_keep <- full_summary
full_summary_bio1_keep <- full_summary_bio1
summary(full_summary$SeedLot == full_summary_bio1$SeedLot)

#Calculate mean difference -------------------------------------------------------------

# Beetroot - Pythium                          # bee
difference_var1 <- c()
for(i in 1:length(unique(beetroot$SeedLot))){
  difference_var1[i] <- mean(beetroot[beetroot$MRTrt=='untrt' & 
                                       beetroot$SeedLot==unique(beetroot$SeedLot)[i],]$inf_count_pre -
                               beetroot[beetroot$MRTrt=='trt'   & 
                                         beetroot$SeedLot==unique(beetroot$SeedLot)[i],]$inf_count_pre)
}

difference_var2 <- c()
for(i in 1:length(unique(beetroot$SeedLot))){
  difference_var2[i] <- mean(beetroot[beetroot$MRTrt=='untrt' & 
                                       beetroot$SeedLot==unique(beetroot$SeedLot)[i],]$inf_count_post -
                               beetroot[beetroot$MRTrt=='trt'   & 
                                         beetroot$SeedLot==unique(beetroot$SeedLot)[i],]$inf_count_post)
}

#keep the info
difference_var1_bee <- data.frame(difference_var1=difference_var1)
difference_var2_bee <- data.frame(difference_var2=difference_var2)

# Onion - Phoma                               # oni1
##(two replicates; data not statistically analysed)
difference_var1_oni1 <- data.frame(difference_var1=c(rep('NA', length(unique(onion$SeedLot)))))
difference_var2_oni1 <- data.frame(difference_var2=c(rep('NA', length(unique(onion$SeedLot)))))

# Onion - Fusarium                            # oni2
difference_var1 <- c()
for(i in 1:length(unique(onion$SeedLot))){
  difference_var1[i] <- mean(onion[onion$MRTrt=='untrt' & 
                                        onion$SeedLot==unique(onion$SeedLot)[i],]$inf_count_pre_13 -
                               onion[onion$MRTrt=='trt'   & 
                                          onion$SeedLot==unique(onion$SeedLot)[i],]$inf_count_pre_13)
}

difference_var2 <- c()
for(i in 1:length(unique(onion$SeedLot))){
  difference_var2[i] <- mean(onion[onion$MRTrt=='untrt' & 
                                        onion$SeedLot==unique(onion$SeedLot)[i],]$inf_count_post_13 -
                               onion[onion$MRTrt=='trt'   & 
                                          onion$SeedLot==unique(onion$SeedLot)[i],]$inf_count_post_13)
}

#keep the info
difference_var1_oni2 <- data.frame(difference_var1=difference_var1)
difference_var2_oni2 <- data.frame(difference_var2=difference_var2)

# Spinach - Pythium                           # spi1
difference_var1 <- c()
for(i in 1:length(unique(spinach$SeedLot))){
  difference_var1[i] <- mean(spinach[spinach$MRTrt=='untrt' & 
                                       spinach$SeedLot==unique(spinach$SeedLot)[i],]$Emerge_count_fin -
                               spinach[spinach$MRTrt=='trt'   & 
                                         spinach$SeedLot==unique(spinach$SeedLot)[i],]$Emerge_count_fin)
}

difference_var2 <- c()
for(i in 1:length(unique(spinach$SeedLot))){
  difference_var2[i] <- mean(spinach[spinach$MRTrt=='untrt' & 
                                       spinach$SeedLot==unique(spinach$SeedLot)[i],]$Inf_count_post -
                               spinach[spinach$MRTrt=='trt'   & 
                                         spinach$SeedLot==unique(spinach$SeedLot)[i],]$Inf_count_post)
}
#keep the info
difference_var1_spi1 <- data.frame(difference_var1=difference_var1)
difference_var2_spi1 <- data.frame(difference_var2=difference_var2)

# Spinach - Fusarium                          # spi2
##(two replicates; data not statistically analysed)
difference_var1_spi2 <- data.frame(difference_var1=c(rep('NA', length(unique(spinach$SeedLot)))))
difference_var2_spi2 <- data.frame(difference_var2=c(rep('NA', length(unique(spinach$SeedLot)))))


# Coriander - Pythium                         # cor
difference_var1 <- c()
for(i in 1:length(unique(coriander$SeedLot))){
  difference_var1[i] <- mean(coriander[coriander$MRTrt=='untrt' & 
                                       coriander$SeedLot==unique(coriander$SeedLot)[i],]$total_emerge2 -
                               coriander[coriander$MRTrt=='trt'   & 
                                         coriander$SeedLot==unique(coriander$SeedLot)[i],]$total_emerge2)
}

difference_var2 <- c()
for(i in 1:length(unique(coriander$SeedLot))){
  difference_var2[i] <- mean(coriander[coriander$MRTrt=='untrt' & 
                                       coriander$SeedLot==unique(coriander$SeedLot)[i],]$Inf_post2 -
                               coriander[coriander$MRTrt=='trt'   & 
                                         coriander$SeedLot==unique(coriander$SeedLot)[i],]$Inf_post2)
}
#keep the info
difference_var1_cor <- data.frame(difference_var1=difference_var1)
difference_var2_cor <- data.frame(difference_var2=difference_var2)

# Pepper - Phytophthora capsici PLANTS              # pep
pepperNAs <- pepper
pepper <- na.omit(pepper)
pepper$Evaluation1 <- as.numeric(pepper$Evaluation1)
pepper$Evaluation2 <- as.numeric(pepper$Evaluation2)
pepper$SeedLot <- as.character(pepper$SeedLot)

difference_var1 <- c()
for(i in 1:length(unique(pepper$SeedLot))){
  difference_var1[i] <- ((mean(pepper[pepper$MRTrt=='untreated' & 
                                         pepper$SeedLot==unique(pepper$SeedLot)[i],]$Evaluation1)) -
                               (mean(pepper[pepper$MRTrt=='treated'   & 
                                           pepper$SeedLot==unique(pepper$SeedLot)[i],]$Evaluation1)))
}


difference_var2 <- c()
for(i in 1:length(unique(pepper$SeedLot))){
  difference_var2[i] <- ((mean(pepper[pepper$MRTrt=='untreated' & 
                                        pepper$SeedLot==unique(pepper$SeedLot)[i],]$Evaluation2)) -
                           (mean(pepper[pepper$MRTrt=='treated'   & 
                                          pepper$SeedLot==unique(pepper$SeedLot)[i],]$Evaluation2)))
}
#keep the info
difference_var1_pep <- data.frame(difference_var1=difference_var1)
difference_var2_pep <- data.frame(difference_var2=difference_var2)


pepper$Evaluation1 <- as.factor(pepper$Evaluation1)
pepper$Evaluation2 <- as.factor(pepper$Evaluation2)
pepper <- pepperNAs

# Pepper - Phytophthora capsici SEEDS              # pep2
difference_var1 <- c()
for(i in 1:length(unique(pep2$SeedLot))){
  difference_var1[i] <- mean(pep2[pep2$MRTrt=='untrt' & 
                                        pep2$SeedLot==unique(pep2$SeedLot)[i],]$Missing -
                               pep2[pep2$MRTrt=='trt'   & 
                                          pep2$SeedLot==unique(pep2$SeedLot)[i],]$Missing)
}

difference_var2 <- c()
for(i in 1:length(unique(pep2$SeedLot))){
  difference_var2[i] <- mean(pep2[pep2$MRTrt=='untrt' & 
                                        pep2$SeedLot==unique(pep2$SeedLot)[i],]$Dead -
                               pep2[pep2$MRTrt=='trt'   & 
                                          pep2$SeedLot==unique(pep2$SeedLot)[i],]$Dead)
}
#keep the info
difference_var1_pep2 <- data.frame(difference_var1=difference_var1)
difference_var2_pep2 <- data.frame(difference_var2=difference_var2)

# Red fescue - Laetisaria fuciformis          # fes
fescue_thread$Disease <- as.numeric(fescue_thread$Disease)
fescue_thread$Disease <- as.numeric(fescue_thread$Disease)

difference_var1 <- c()
for(i in 1:length(unique(fescue_thread$SeedLot))){
  difference_var1[i] <- mean(fescue_thread[fescue_thread$MRTrt=='untreated' & 
                                      fescue_thread$SeedLot==unique(fescue_thread$SeedLot)[i],]$Disease -
                               fescue_thread[fescue_thread$MRTrt=='treated'   & 
                                        fescue_thread$SeedLot==unique(fescue_thread$SeedLot)[i],]$Disease)
}

difference_var1_fes <- data.frame(difference_var1=difference_var1)
difference_var2_fes <- data.frame(difference_var2=c(rep('NA', length(unique(fescue_thread$SeedLot)))))
fescue_thread$Disease <- as.factor(fescue_thread$Disease)
fescue_thread$Disease <- as.factor(fescue_thread$Disease)

# Perennial ryegrass - Laetisaria fuciformis  # per1
perennial_thread$Disease <- as.numeric(perennial_thread$Disease)
perennial_thread$Disease <- as.numeric(perennial_thread$Disease)
difference_var1 <- c()
for(i in 1:length(unique(perennial_thread$SeedLot))){
  difference_var1[i] <- mean(perennial_thread[perennial_thread$MRTrt=='untreated' & 
                                             perennial_thread$SeedLot==unique(perennial_thread$SeedLot)[i],]$Disease -
                               perennial_thread[perennial_thread$MRTrt=='treated'   & 
                                               perennial_thread$SeedLot==unique(perennial_thread$SeedLot)[i],]$Disease)
}

difference_var1_per1 <- data.frame(difference_var1=difference_var1)
difference_var2_per1 <- data.frame(difference_var2=(rep('NA', length(unique(perennial_thread$SeedLot)))))

perennial_thread$Disease <- as.factor(perennial_thread$Disease)
perennial_thread$Disease <- as.factor(perennial_thread$Disease)

# Perennial ryegrass - Puccinia               # per2
perennial_puccinia$Disease <- as.numeric(perennial_puccinia$Disease)
perennial_puccinia$Disease <- as.numeric(perennial_puccinia$Disease)
difference_var1 <- c()
for(i in 1:length(unique(perennial_puccinia$SeedLot))){
  difference_var1[i] <- mean(perennial_puccinia[perennial_puccinia$MRTrt=='untreated' & 
                                                perennial_puccinia$SeedLot==unique(perennial_puccinia$SeedLot)[i],]$Disease -
                               perennial_puccinia[perennial_puccinia$MRTrt=='treated'   & 
                                                  perennial_puccinia$SeedLot==unique(perennial_puccinia$SeedLot)[i],]$Disease)
}

difference_var1_per2 <- data.frame(difference_var1=difference_var1)
difference_var2_per2 <- data.frame(difference_var2=c(rep('NA', length(unique(perennial_puccinia$SeedLot)))))

perennial_puccinia$Disease <- as.factor(perennial_puccinia$Disease)
perennial_puccinia$Disease <- as.factor(perennial_puccinia$Disease)

#Combine mean difference and manually adjust +/- to standardise directionality for all -------------------------------------------------------------

difference_var1_all <- rbind(difference_var1_bee,    #infection                                   Beetroot_Pythium
                             difference_var1_oni1,   #NA but invert + and - for consistency       Onion_Phoma
                             difference_var1_oni2,   #infection                                   Onion_Fusarium
                             -difference_var1_spi1,  #invert + and - for consistency              Spinach_Pythium
                             difference_var1_spi2,   #NA but invert + and - for consistency       Spinach_Fusarium
                             -difference_var1_cor,   #invert + and - for consistency              Coriander_Pythium
                             -difference_var1_pep,   #invert + and - for consistency              Pepper plants_Phytophthora capsici
                             difference_var1_pep2,   #infection                                   Pepper seeds_Phytophthora capsici
                             difference_var1_per1,   #infection                                   Perennial ryegrass_Laetisaria fuciformis
                             difference_var1_per2,   #infection                                   Perennial ryegrass_Puccinia sp.
                             difference_var1_fes)    #infection                                   Red fescue_Laetisaria fuciformis
difference_var2_all <- rbind(difference_var2_bee,    #infection                                   Beetroot_Pythium
                             difference_var2_oni1,   #NA but invert + and - for consistency       Onion_Phoma
                             difference_var2_oni2,   #infection                                   Onion_Fusarium
                             difference_var2_spi1,   #infection                                   Spinach_Pythium
                             difference_var2_spi2,   #NA but invert + and - for consistency       Spinach_Fusarium
                             difference_var2_cor,    #infection                                   Coriander_Pythium
                             -difference_var2_pep,   #invert + and - for consistency              Pepper plants_Phytophthora capsici
                             difference_var2_pep2,   #infection                                   Pepper seeds_Phytophthora capsici
                             difference_var2_per1,   #NA                                          Perennial ryegrass_Laetisaria fuciformis
                             difference_var2_per2,   #NA                                          Perennial ryegrass_Puccinia sp.
                             difference_var2_fes)    #NA                                          Red fescue_Laetisaria fuciformis



#Incorporate mean difference on summary data to assign categories -------------------------------------------------------------
#i.e. promising/non-responsive/negative

head(full_summary)
head(full_summary_bio1)

test <- cbind(full_summary, full_summary_bio1)
summary(test[,1] == test[,8]) #seed lots align

full_summary_bio <- cbind(full_summary_bio1, 
                          difference_var1=difference_var1_all, 
                          difference_var2=difference_var2_all)


full_summary_bio <-full_summary_bio[,2:5] #remove seed lot column to avoid repetition
full_summary2 <- cbind(full_summary, full_summary_bio)

head(full_summary2)

full_summary2$P_value_bio1 <- as.numeric(full_summary2$P_value_bio1)
full_summary2$P_value_bio2 <- as.numeric(full_summary2$P_value_bio2)

full_summary2$difference_var1 <- as.numeric(full_summary2$difference_var1)
full_summary2$difference_var2 <- as.numeric(full_summary2$difference_var2)



#record which seed lots are promising, non-responsive or negatively responsive (last one done manually)
full_summary2$Bio_var1 [full_summary2$P_value_bio1  < 0.05]    <- "Promising seed lots"
full_summary2$Bio_var1 [(full_summary2$P_value_bio1  < 0.05)&
                        (full_summary2$difference_var1 > 0)]   <- "Negatively responsive seed lots"
full_summary2$Bio_var1 [(full_summary2$P_value_bio1  >= 0.05)] <- "Non-responsive seed lots"
full_summary2$Bio_var1 [full_summary2$P_value_bio1  == "NA"]   <- "NA"
full_summary2$Bio_var2 [full_summary2$P_value_bio2  < 0.05]    <- "Promising seed lots"
full_summary2$Bio_var2 [(full_summary2$P_value_bio2  < 0.05)&
                        (full_summary2$difference_var2 > 0)]   <- "Negatively responsive seed lots"
full_summary2$Bio_var2 [(full_summary2$P_value_bio2  >= 0.05)] <- "Non-responsive seed lots"
full_summary2$Bio_var2 [full_summary2$P_value_bio2  == "NA"]   <- "NA"


#manually adjust columns for onion-Phoma and spinach-Fusarium since those bioassays had two replicates only 
#and were not statistically analysed

OP_SF <- read.csv('OnionPhoma_SpinachFusarium.csv') #also includes one negatively responsive seed lot for onion_Phoma

full_summary2$Bio_var1[full_summary2$BioassayType=='Onion_Phoma'] <- OP_SF$Bio_var1[OP_SF$BioassayType=='Onion_Phoma']
full_summary2$Bio_var1[full_summary2$BioassayType=='Spinach_Fusarium'] <- OP_SF$Bio_var1[OP_SF$BioassayType=='Spinach_Fusarium']

full_summary2$Bio_var2[full_summary2$BioassayType=='Onion_Phoma'] <- OP_SF$Bio_var2[OP_SF$BioassayType=='Onion_Phoma']
full_summary2$Bio_var2[full_summary2$BioassayType=='Spinach_Fusarium'] <- OP_SF$Bio_var2[OP_SF$BioassayType=='Spinach_Fusarium']

